/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.integration.jei;

import com.google.common.collect.ImmutableList;
import dev.ftb.extendedexchange.block.ModBlocks;
import dev.ftb.extendedexchange.client.gui.AbstractEXScreen;
import dev.ftb.extendedexchange.client.gui.AlchemyTableScreen;
import dev.ftb.extendedexchange.client.gui.ArcaneTabletScreen;
import dev.ftb.extendedexchange.integration.jei.AlchemyTableCategory;
import dev.ftb.extendedexchange.integration.jei.ArcaneTabletGuiArea;
import dev.ftb.extendedexchange.integration.jei.ArcaneTabletTransfer;
import dev.ftb.extendedexchange.integration.jei.EMCLinkJEI;
import dev.ftb.extendedexchange.integration.jei.RecipeTypes;
import dev.ftb.extendedexchange.item.ModItems;
import dev.ftb.extendedexchange.recipes.ModRecipeTypes;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("extendedexchange", "default");
    static IJeiHelpers jeiHelpers;
    static IJeiRuntime runtime;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new AlchemyTableCategory()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addRecipeType(registration, (net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.ALCHEMY_TABLE.get(), RecipeTypes.ALCHEMY_TABLE);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ALCHEMY_TABLE.get()), new RecipeType[]{RecipeTypes.ALCHEMY_TABLE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.ARCANE_TABLET.get()), new RecipeType[]{mezz.jei.api.constants.RecipeTypes.CRAFTING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AlchemyTableScreen.class, 78, 35, 23, 14, new RecipeType[]{RecipeTypes.ALCHEMY_TABLE});
        registration.addGhostIngredientHandler(AbstractEXScreen.class, new EMCLinkJEI());
        registration.addGuiContainerHandler(ArcaneTabletScreen.class, (IGuiContainerHandler)new ArcaneTabletGuiArea());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)new ArcaneTabletTransfer(registration.getTransferHelper()));
    }

    private <C extends Container, T extends Recipe<C>> void addRecipeType(IRecipeRegistration registration, net.minecraft.world.item.crafting.RecipeType<T> type, RecipeType<T> recipeType) {
        List recipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(type);
        registration.addRecipes(recipeType, (List)ImmutableList.copyOf((Collection)recipes));
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public static void setFilterText(String text) {
        runtime.getIngredientFilter().setFilterText(text);
    }
}

